#include "General.h"
#include "SetDeathsConsoleCommand.h"
#include "DamageableGameObj.h"
#include "CommandLineParser.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "engine_game.h"
#include "ScriptableGameObj.h"
#include "DefenseObjectClass.h"
#include "gmgame.h"
#include "Iterator.h"

static int getClientIdByIdentifier(const char* clientIdentifier)
{
	assert(clientIdentifier);
	const cPlayer* player = Find_Player(atoi(clientIdentifier));
	int result;
	if (player)
		result = player->PlayerId;
	else
		result = -1;
	return result;
}

static bool isClientId(const int id)
{
	return id > 0 && id < 128 && Find_Player(id);
}

class CommandSETDEATHS : public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "setdeaths"; 
	}
	const char* Get_Help() 
	{ 
		return "SETDEATHS <ID> <VALUE> - changes the deaths count of a player.\n"; 
	}
	void Activate(const char* argumentsString)
	{
		CommandLineParser arguments(argumentsString);
		const char* clientIdentifier = arguments.getString();

		if (!clientIdentifier || clientIdentifier[0] == '\0')
			Console_Output("Please a player ID.\n");
		else
		{
			const int clientId = getClientIdByIdentifier(clientIdentifier);
			if (!isClientId(clientId))
			{
				Console_Output("Please enter a valid player ID.");
			}
			else
			{
//				int Value = arguments.getInt();
				bool ValidNumber = true;

				const char* string = arguments.getRemainingString();
				if (!string)
					ValidNumber = false;

				// Check whether the string is a valid number
				for (const char* s = string; *s != '\0'; ++s)
				{
					if (*s < '0' || *s > '9')
					{
						if (*s == '-') continue;
						ValidNumber = false;
					}
				}
				// Return the converted string
				if (ValidNumber == true) 
				{	
					int Value = atoi(string);
					Find_Player(clientId)->Set_Deaths(Value);
				}
				else
				{
					Console_Output("Please enter a (valid) value to set the deaths count to\n");
				}
			}
		}
	}
};

class SetDeathsConsoleCommand : public Plugin
{
public:
	SetDeathsConsoleCommand()
	{
		ConsoleFunctionList.Add(new CommandSETDEATHS);
		Sort_Function_List();
		Verbose_Help_File();
	}
	~SetDeathsConsoleCommand()
	{
		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{ 
				if (strcmp(name, "setdeaths") == 0 || strcmp(name, "setdeaths") == 0)
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}	
};

SetDeathsConsoleCommand setDeathsConsoleCommand;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &setDeathsConsoleCommand;
}